/****
 * CMemDisplay.c
 *
 *	A small pane that display the amount of memory left in
 *  the application heap.
 *
 ****/
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#include "CMemDisplay.h"

void	CMemDisplay::IMemDisplay(CView *anEnclosure, CBureaucrat *aSupervisor)
{
	IPanorama(anEnclosure, aSupervisor,
		10, 10, 0, 0, sizELASTIC, sizELASTIC);
}

void	CMemDisplay::Draw(Rect *area)
{
	Str255 str;

	Prepare();

	MoveTo(5, 12);
	NumToString(StackSpace(), str);
	DrawString(str);

	MoveTo(5, 24);
	NumToString(FreeMem(), str);
	DrawString(str);
}

